#ifndef __C_IPENDPOINT_H
#define __C_IPENDPOINT_H

#include "Endpoint/cEndpoint.h"
#include <winsock2.h>

/*
 * cIPEndpoint.h
 *
 * IP endpoint class.
 */
class cIPEndpoint : public cEndpoint
{
  public:
	friend class cNetworkLayer;	// The network layer can access it's members.

	static const unsigned int DEFAULT_SUBNET_MASK;

	cIPEndpoint();
	cIPEndpoint(char* address, u_short port);

	unsigned int	HashCode();

	bool Equals(cHashObject* hObj);
	bool LessThan(cHashObject* hObj);
	bool SubnetLessThan(cEndpoint* ep);
	bool IsSameSubnet(cEndpoint* ep);
	cEndpoint* AllocCopy();

	char* Serialize(char* buffer, int *size);
	char* Deserialize(char* buffer, int *size);

	unsigned int GetSize();
	void Print(ostream &errStream);
	sockaddr_in	GetIPAddr()	{ return mAddress; }

  private:

	unsigned int	_ComputeHashCode();
	u_long			_GetAddr(char* addr);

	unsigned int	mHashCode;
	sockaddr_in		mAddress;
	__int32			mSubnetMask;
};

#endif